---
title: List JSON object · Cloudflare Web Application Firewall (WAF) docs
description: Reference information on the JSON object used in Lists API calls.
lastUpdated: 2025-09-12T15:50:27.000Z
chatbotDeprioritize: false
tags: JSON
source_url:
  html: https://developers.cloudflare.com/waf/tools/lists/lists-api/json-object/
  md: https://developers.cloudflare.com/waf/tools/lists/lists-api/json-object/index.md
---

## List object structure and properties

A JSON response for the [Lists API](https://developers.cloudflare.com/api/resources/rules/subresources/lists/) has this structure:

```json
{
  "id": "2c0fc9fa937b11eaa1b71c4d701ab86e",
  "name": "my_list_name",
  "description": "List description.",
  "kind": "(ip|hostname|asn|redirect)",
  "num_items": 10,
  "num_referencing_filters": 2,
  "created_on": "2021-01-01T08:00:00Z",
  "modified_on": "2021-01-10T14:00:00Z"
}
```

This table summarizes the object properties:

| Property | Description | Constraints |
| - | - | - |
| `id` String | A UUIDv4 identifier generated by Cloudflare. | Unique, read only.Length: 32 characters. |
| `name` String | An informative name for the list. | Maximum length: 50 characters.Only alphanumeric and underscore (`_`) characters are valid.A valid name satisfies this regular expression: `^[a-zA-Z0-9_]+$`. |
| `description` String | An informative summary of the list. | Maximum length: 500 characters. |
| `kind` String | The type of data in the list. | Valid values: `ip`, `hostname`, `asn`, `redirect`. |
| `num_items` Number | The number of items in the list. | Read only. |
| `num_referencing_filters` Number | The number of filters that reference this list. | Read only. |
| `created_on` String | The [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) timestamp the list was created. | Read only. |
| `modified_on` String | The [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) timestamp when the list was last modified. | Read only. |

## List item object structure and properties

Each list type (IP address, hostname, ASN, redirects) can only contain items of the same type.

### IP address

A fully populated JSON object for an IP address list item has the following structure:

```json
{
  "id": "7c5dae5552338874e5053f2534d2767a",
  "ip": "10.0.0.1/32",
  "comment": "CF DNS server",
  "created_on": "2021-10-01T05:20:00.12345Z",
  "modified_on": "2021-10-01T05:20:00.12345Z"
}
```

### Hostname

A fully populated JSON object for a hostname list item has the following structure:

```json
{
  "id": "7c5dae5552338874e5053f2534d2767a",
  "hostname": {
    "url_hostname": "*.example.com"
  },
  "created_on": "2021-10-11T12:39:02Z",
  "modified_on": "2021-10-11T12:39:02Z"
}
```

### ASN

A fully populated JSON object for an ASN list item has the following structure:

```json
{
  "id": "7c5dae5552338874e5053f2534d2767a",
  "asn": 13335,
  "comment": "My provider's ASN",
  "created_on": "2021-10-11T12:39:02Z",
  "modified_on": "2021-10-11T12:39:02Z"
}
```

### URL redirect

A fully populated JSON object for a Bulk Redirect List item has the following structure:

```json
{
  "id": "7c5dae5552338874e5053f2534d2767a",
  "redirect": {
    "source_url": "https://example.com/blog",
    "target_url": "https://example.com/blog/latest",
    "status_code": 301,
    "include_subdomains": false,
    "subpath_matching": false,
    "preserve_query_string": false,
    "preserve_path_suffix": true
  },
  "created_on": "2021-10-11T12:39:02Z",
  "modified_on": "2021-10-11T12:39:02Z"
}
```

### Properties reference

The JSON object properties for a list item are defined as follows:

| Property | Description | Constraints |
| - | - | - |
| `id` String | A UUIDv4 identifier generated by Cloudflare. | Unique, read only.Length: 32 characters. |
| `ip` String | An IP address or CIDR range. | Applies only to custom lists with IP addresses (IP lists).Any of these formats can exist in the same custom list with IP addresses:- IPv4 address
- IPv6 address
- IPv4 ranges as `/8` through `/32` CIDRs
- IPv6 ranges as `/12` through `/128` CIDRs |
| `comment` String | An informative summary of the item. | Maximum length: 500 characters. |
| `redirect` Object | An object that contains the definition of a URL redirect. Refer to [URL redirect parameters](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/reference/parameters/) for details. | Applies only to Bulk Redirect Lists. |
| `hostname` Object | An object containing a `url_hostname` property with a hostname value. Refer to [Lists with hostnames](https://developers.cloudflare.com/waf/tools/lists/custom-lists/#lists-with-hostnames) for details on the supported hostname values. | Applies only to custom lists with hostnames. |
| `asn` Integer | An ASN value. | Applies only to custom lists with ASNs. |
| `created_on` String | The [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) timestamp when the list was created. | Read only. |
| `modified_on` String | The [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) timestamp when the item was last modified. | Read only. |

For a detailed specification, refer to the [Lists API](https://developers.cloudflare.com/api/resources/rules/subresources/lists/) documentation.
