---
title: Examples · Cloudflare Style Guide
description: The true value of AI is not just in using it; it is in how you use
  it. At Cloudflare, our team has embraced AI as a force multiplier, allowing us
  to solve internal challenges, scale our expertise, and improve the quality of
  our work.
lastUpdated: 2025-11-12T20:09:05.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/examples/
  md: https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/examples/index.md
---

The true value of AI is not just in using it; it is in *how* you use it. At Cloudflare, our team has embraced AI as a **force multiplier**, allowing us to solve internal challenges, scale our expertise, and improve the quality of our work.

These are not just off-the-shelf AI products. They are tools built *by* Cloudflare, *for* Cloudflare, combining our own institutional knowledge, content standards, and logic with the power of AI models.

## Why we build our own AI-powered tools

Our AI-powered solutions have a dual benefit:

1. **For our team:** They help us automate manual processes, scale our impact, and focus on higher-value strategic work.
2. **For Cloudflare:** They empower all our colleagues — from product to engineering — to make better decisions, create higher-quality content, and understand our users more deeply.

We have seen a lot of success with this approach, as it allows us to democratize specialized skills. We can embed content strategy, style guide rules, and user feedback analysis directly into the workflows of the people who need it most.

These tools range in complexity, role, and use case, from simple, locally-run scripts that automate a repetitive chore to full-fledged applications that serve the entire company.

The following sections provide examples of these tools and our guiding principles. We cover how they were built, the specific problems they solve, and the practical guidelines we've established for using AI effectively.

* [CLUE](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/examples/clue/)
* [Cloudspeaker](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/examples/cloudspeaker/)
