---
title: Timed DNS policies · Cloudflare One docs
description: By default, Cloudflare Gateway policies apply at all times when
  turned on. With timed DNS policies, you can control when DNS policies are
  active. You can configure a policy to be active during specific time periods
  or set the policy to expire after a certain duration.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/timed-policies/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/timed-policies/index.md
---

By default, Cloudflare Gateway policies apply at all times when turned on. With timed DNS policies, you can control when DNS policies are active. You can configure a policy to be active during specific time periods or set the policy to expire after a certain duration.

There are two timed DNS policy options:

* [Policy duration](#policy-duration): The policy is active for a specific amount of time after being turned on (for example, 30 minutes).
* [Policy schedule](#policy-schedule): The policy is active during a recurring weekly schedule (for example, weekdays from 9 AM to 5 PM).

## Policy duration

You can use a time-based policy duration to set a specific time frame for the policy to turn on or configure an exact time for the policy to turn off.

To set a duration for a DNS policy:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies** > **DNS**.

2. Create a new DNS policy or choose an existing policy and select **Edit**.

3. In **Apply durations and schedules**, turn on **Policy duration**.

4. In **Input method**, choose the type of duration:

   * Choose *Duration* and enter a specific amount of time until the policy turns off.
   * Choose *Exact end date* and enter a specific date and time in your account's time zone for the policy to turn off.

5. Select **Save policy**.

When a policy turns off, it will remain off until you turn it back on.

Policies with a set duration will retain their duration when turned off or on. For example, you can create a policy at 12:00 PM and set it to turn off after six hours. If you turn the policy off at 3:00 PM and turn it back on 4:00 PM, the policy will still turn off at 6:00 PM, six hours after the original time.

### Reset a policy's duration

When a policy's time duration expires, you can turn the policy back on for the duration you originally configured. To reset a policy's duration, select the policy and choose **Reset policy duration**.

For policies with an exact end time, you can change the time before the policy turns off. Once the policy reaches its exact end time, you will need to edit the policy and set a new end time. To set a new exact end time:

1. Select the policy.
2. Choose **Edit**.
3. Turn on **Set a policy duration**.
4. In **Input method**, choose *Exact end date*. In **Date and time**, enter a new date and time for the policy to turn off.
5. Select **Save policy**.

## Policy schedule

You can use Gateway to create a new DNS policy with a schedule or add a schedule to an existing policy.

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies** > **DNS**.
  2. Create a new DNS policy or choose an existing policy and select **Edit**.
  3. In **Apply durations and schedules**, turn on **Policy schedule**.
  4. (Optional) In **Time Zone**, choose a time zone to apply the policy based on the time zone you select, regardless of the user's location. By default, Gateway will use the end user's time zone to apply the policy based on the local time of the user making the DNS query.
  5. In **Schedule template**, choose a preset schedule, or choose *Custom schedule* to define a custom schedule. You can choose up to three non-overlapping time ranges of 15 minute intervals.
  6. Select **Save policy**.

* API

  To schedule a policy with the API, use the [Create a Zero Trust Gateway rule endpoint](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) with the `schedule` parameter set to your desired days of the week, times of day, and an optional time zone. For example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "action": "block",
      "name": "Block gambling sites on weekends",
      "traffic": "any(dns.content_category[*] in {\"Gambling\"})",
      "schedule": {
          "sat": "08:00-17:00",
          "sun": "08:00-17:00",
          "timezone": "Europe/Paris"
      }
    }'
  ```

The policy's schedule will appear in Cloudflare One under **Traffic policies** > **Firewall policies** > **DNS** when you select the policy.

### How Gateway determines time zone

If you [assign a time zone](#example-fixed-time-zone) to your schedule, Gateway will always use the current time at that time zone regardless of the user's location. This allows you to enable a policy during a certain fixed time period.

If you [do not specify a time zone](#example-users-time-zone), Gateway will enable the DNS policy based on the user's local time zone. The user's time zone is inferred from the IP geolocation of their source IP address. If Gateway is unable to determine the time zone from the source IP, we will fall back to the time zone of the data center where the query was received.

#### Example: Fixed time zone

The following command creates a DNS policy to block `facebook.com` only on weekdays from 8:00 AM - 12:30 PM and 1:30 PM - 5:00 PM in the Chicago, USA time zone.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zero Trust Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "name": "office-no-facebook-policy",
    "action": "block",
    "traffic": "dns.fqdn == \"facebook.com\"",
    "enabled": true,
    "schedule": {
        "time_zone": "America/Chicago",
        "mon": "08:00-12:30,13:30-17:00",
        "tue": "08:00-12:30,13:30-17:00",
        "wed": "08:00-12:30,13:30-17:00",
        "thu": "08:00-12:30,13:30-17:00",
        "fri": "08:00-12:30,13:30-17:00"
    }
  }'
```

Refer to [this table](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List) for a list of all time zone identifiers.

#### Example: User's time zone

The following command creates a DNS policy to block `clockin.com` only on weekends in the time zone where the user is currently located.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zero Trust Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "name": "clock-in-policy",
    "action": "block",
    "traffic": "dns.fqdn == \"clockin.com\"",
    "enabled": true,
    "schedule": {
        "sat": "00:00-24:00",
        "sun": "00:00-24:00"
    }
  }'
```

Note

Gateway will not change the policy's `enabled` status when inside or outside of the time period specified. When enabled, Gateway activates or deactivates the policy according to its schedule. When disabled, the policy is always deactivated.
